 aR  w Q mP9      h	 oP       nSystem-wide/*        This file is IntMsCalls.Ext.Inc        */

/* This module contains the PLM interface to the */
/* RTD version of many of the MsDOS calls.       */

/* THIS VERSION ONLY EXPORTS CALLS THAT ARE USED */
/* BY INTERCEPTOR.  IF YOU NEED OTHER CALLS THEN */
/* USE MSCALLS.EXT.INC.                          */

/* Error codes */

DCL eMsOK              LIT '0';
DCL eMsInvalidParm     LIT '1';
DCL eMsFileNotFound    LIT '2';
DCL eMsPathNotFound    LIT '3';
DCL eMsTooManyOpen     LIT '4';
DCL eMsAccessDenied    LIT '5';
DCL eMsInvalidConn     LIT '6';
DCL eMsMemoryTrashed   LIT '7';
DCL eMsOutOfMemory     LIT '8';
DCL eMsInvalidBlock    LIT '9';
DCL eMsBadEnvironment  LIT '10';
DCL eMsBadFormat       LIT '11';
DCL eMsInvalidAccess   LIT '12';
DCL eMsInvalidData     LIT '13';

DCL eMsInvalidDrive    LIT '15';
DCL eMsDirectoryInUse  LIT '16';
DCL eMsNotSameDevice   LIT '17';
DCL eMsNoMoreFiles     LIT '18';


/* Attach Modes */

DCL attachOldMode      LIT '1';
DCL attachUpdateMode   LIT '2';
DCL attachNewMode      LIT '3';

/* Attach accesses */

DCL attachReadAccess   LIT '0';
DCL attachWriteAccess  LIT '1';
DCL attachUpdateAccess LIT '2';

/* Attach attributes */

DCL normalFile         LIT '00H';
DCL readOnlyFile       LIT '01H';
DCL hiddenFile         LIT '02H';
DCL systemFile         LIT '04H';
DCL volumeLabelFile    LIT '08H';
DCL directoryFile      LIT '10H';
DCL archiveBit         LIT '20H';


/* Seek Modes */

DCL seekBegPlus        LIT '0';
DCL seekCurPlus        LIT '1';
DCL seekEndPlus        LIT '2';


/* FCB Read Modes */

DCL readSeq            LIT '0';
DCL readRnd            LIT '1';
DCL readRndBlk         LIT '2';


/* FCB Write Modes */

DCL writeSeq           LIT '0';
DCL writeRnd           LIT '1';
DCL writeRndBlk        LIT '2';
$EJECT

/* Structures */

DCL LineInType         LIT 'STRUCTURE
(maxChars      BYTE,
 actualChars   BYTE,
 chars (1)     BYTE)';

DCL ParamBlockType 	   LIT 'STRUCTURE
 (sEnvironment	SELECTOR,
		pCommandLine	PTR,
  pFcb1        PTR,
  pFcb2        PTR)';


/* File Control Block */

DCL FcbType            LIT 'STRUCTURE
(BasicFcbPart)';

DCL ExtendedFcbType    LIT 'STRUCTURE
(flag          BYTE,
 reserved1 (5) BYTE,
 attribute     BYTE,
 BasicFcbPart)';

DCL BasicFcbPart       LIT
'driveNumber   BYTE,
 fileName (8)  BYTE,
 extension (3) BYTE,
 currentBlock  WORD,
 recordSize    WORD,
 fileSize      DWORD,
 lastModDate   WORD,
 lastModTime   WORD,
 reserved2 (8) BYTE,
 currentRecd   BYTE,
 relativeRecd  DWORD';

DCL ofBit              LIT '0800h';
DCL dfBit              LIT '0400h';
DCL ifBit              LIT '0200h';
DCL tfBit              LIT '0100h';
DCL sfBit              LIT '0080h';
DCL zfBit              LIT '0040h';
DCL afBit              LIT '0010h';
DCL pfBit              LIT '0004h';
DCL cfBit              LIT '0001h';

DCL RegistersType      LIT 'STRUCTURE
(es            WORD,
 ds            WORD,
 bp            WORD,
 di            WORD,
 si            WORD,
 dx            WORD,
 cx            WORD,
 bx            WORD,
 ax            WORD,
 flags         WORD)';
$EJECT

/* These are the only calls used by Interceptor */

/* THESE ARE USED BY EITHER INTRCEPT */
/* OR PHONELINK OR GRIDLINK ALWAYS   */

MsGetDiskXferAddr: PROCEDURE PTR EXTERNAL;
  END;

MsGetCurrentDisk: PROCEDURE BYTE EXTERNAL;
  END;

MsSetCurrentDisk: PROCEDURE (drive) BYTE EXTERNAL;
  DCL drive      BYTE;
  END;

MsDeviceListPtr: PROCEDURE PTR EXTERNAL;
  END;

MsDuplicateFileConn: PROCEDURE (conn, newConn, pError) WORD EXTERNAL;
  DCL conn       WORD;
  DCL newConn    WORD;
  DCL pError     PTR;
  END;

MsDetach: PROCEDURE (conn, pError) EXTERNAL;
  DCL conn       WORD;
  DCL pError     PTR;
  END;


/* THESE ARE FOR PHONELINK ONLY */

$IF PHONELINK
MsKeyPressed: PROCEDURE BOOLEAN EXTERNAL;
  END;

MsCharIn: PROCEDURE BYTE EXTERNAL;
  END;

MsCallDriver: PROCEDURE (pDeviceHeader, pRequestBlock) EXTERNAL;
  DCL pDeviceHeader   PTR;
  DCL pRequestBlock   PTR;
  END;
$ENDIF


/* THESE ARE FOR GRIDLINK & PHONELINK DEBUG ONLY */

$IF DEBUG
MsCharOut: PROCEDURE (char) EXTERNAL;
  DCL char       BYTE;
  END;

MsLineOut: PROCEDURE (pLine) EXTERNAL;
  DCL pLine      PTR;
  END;

MsInMsDosPtr: PROCEDURE PTR EXTERNAL;
  END;

MsAttach: PROCEDURE (pPathName, mode, access, attribute, pError) WORD EXTERNAL;
  DCL mode       BYTE;
  DCL access     BYTE;
  DCL attribute  WORD;
  DCL pPathname  PTR;
  DCL pError     PTR;
  END;

MsSeek: PROCEDURE (conn, mode, count, pError) DWORD EXTERNAL;
  DCL mode       BYTE;
  DCL conn       WORD;
  DCL count      DWORD;
  DCL pError     PTR;
  END;

MsWrite: PROCEDURE (conn, pBuffer, count, pError) WORD EXTERNAL;
  DCL conn       WORD;
  DCL count      WORD;
  DCL pBuffer    PTR;
  DCL pError     PTR;
  END;
$ENDIF
